# Using Code Coverage in batchmode

There are 4 arguments that can be passed in batchmode:

**-enableCodeCoverage**, to enable code coverage.  
**-coverageResultsPath** (_optional_), to set the location where the coverage results and report will be saved to. The default location is the project's path.  
**-coverageHistoryPath** (_optional_), to set the location where the coverage report history will be saved to. The default location is the project's path.  
**-coverageOptions** (_optional_), to pass extra options. This is semicolon separated.   

|Coverage Option|Description|
|:---|:---|
|`generateHtmlReport`|Add this to generate a coverage HTML report.|
|`generateHtmlReportHistory`|Add this to generate and include the coverage history in the HTML report.|
|`generateBadgeReport`|Add this to generate coverage summary badges in SVG and PNG format.|
|`generateAdditionalMetrics`|Add this to generate and include additional metrics in the HTML report. These currently include Cyclomatic Complexity and Crap Score calculations for each method. See the [Risk Hotspots](HowToInterpretResults.md#risk-hotspots) section for more information.|
|`verbosity`|Add this to set the verbosity level of the log messages. The default value is `info`.<br/>**Values:** `verbose`, `info`, `warning`, `error`, `off`|
|`assemblyFilters`|Add this to specify the assemblies that should be included or excluded in the coverage calculation and/or report. This is a comma separated string. Prefix assemblies with `+` to include them and with `-` to exclude them. Globbing can be used to filter the assemblies.<br/><br/>**Available aliases:**<br/><br/>`<user>` maps to the assemblies under the *Assets* folder.<br/>`<project>` maps to all the assemblies in the project.<br/>`<packages>` maps to the Packages' assemblies in the project, including the built-in packages.<br/><br/>**By default, if there are no included assemblies specified, only the assemblies under the *Assets* folder will be included.**<br/><br/>**Examples:**<br/><br/>`assemblyFilters:+<project>` will include code from all the assemblies in the project.<br/>`assemblyFilters:+my.assembly` will only include code from the assembly called _my.assembly_.<br/>`assemblyFilters:+unity.*` will include code from any assembly whose name starts with _unity._<br/>`assemblyFilters:-*unity*` will exclude code from all assemblies that contain the word _unity_ in their names.<br/>`assemblyFilters:+my.assembly.*,-my.assembly.tests` will include code from any assembly whose name starts with _my.assembly._, but will explicitly exclude code from the assembly called _my.assembly.tests_.<br/>`assemblyFilters:+my.locale.??` will only inlcude code from assemblies whose names match this format, e.g. _my.locale.en_, _my.locale.99_, etc.<br/>`assemblyFilters:+my.assembly.[a-z][0-9]` will only inlcude code from assemblies whose names match this format, e.g. _my.assembly.a1_, _my.assembly.q7_, etc.|
|`pathFilters`|Add this to specify the paths that should be included or excluded in the coverage calculation and/or report. This is a comma separated string. Prefix paths with `+` to include them and with `-` to exclude them. Globbing can be used to filter the paths.<br/><br/>Currently, only absolute paths are supported. However, you can use globbing to make them shorter e.g. `*/Assets/Scripts/`. We are exploring allowing relative paths in a future release.<br/><br/>**Examples:**<br/><br/>`pathFilters:+C:/MyProject/Assets/MyClass.cs` will only include the _MyClass.cs_ file.<br/>`pathFilters:-C:/MyProject/Assets/AutoGenerated/*` will exclude all files under the _C:/MyProject/Assets/AutoGenerated_ folder.<br/>`pathFilters:+*/Assets/Editor/*` will include just the files that have _/Assets/Editor/_ in their path.<br/>`pathFilters:+C:/MyProject/Assets/**/MyClass.cs` will include any file named _MyClass.cs_ that is under the _C:/MyProject/Assets_ folder and any of its subfolders.<br/>`pathFilters:+C:/MyProject/*,-*/Packages/*` will only include files under _C:/MyProject/_ folder and exclude all files under any _Packages_ folder.<br/>`pathFilters:+*/MyGeneratedClass_??.cs` will include only files with filenames that match this format, i.e. _MyGeneratedClass_01.cs_, _MyGeneratedClass_AB.cs_, etc.<br/>`pathFilters:+*/MyClass_[A-Z][0-9].cs` will include only files with filenames that match this format, i.e. _MyClass_A1.cs_, _MyClass_Q7.cs_, etc.|

**Note:** If `pathFilters` are specified and there are no included assemblies specified in `assemblyFilters`, then all the assemblies in the project are included in order for _path filtering_ to take precedence over _assembly filtering_.

## Example

```
Unity.exe -projectPath <path-to-project> -batchmode -testPlatform editmode -runTests -testResults
<path-to-results-xml> -debugCodeOptimization 
-enableCodeCoverage
-coverageResultsPath <path-to-coverage-results>
-coverageHistoryPath <path-to-coverage-history>
-coverageOptions generateAdditionalMetrics;generateHtmlReport;generateHtmlReportHistory;generateBadgeReport;
assemblyFilters:+my.assembly.*,+<packages>;
pathFilters:-*/Tests/*,-*/BuiltInPackages/*;
verbosity:verbose
```
The example above will open the project at _\<path-to-project\>_, run the _EditMode_ tests and produce an HTML coverage report and coverage summary badges in _\<path-to-coverage-results\>_. The report will include the coverage history, Cyclomatic Complexity and Crap Score calculations. The coverage history files will be saved in _\<path-to-coverage-history\>_.

Additionally, the report will include code from any assembly whose name starts with _my.assembly._, as well as include code from all the Packages' assemblies, but will exclude files that have _/Tests/_ in their path (i.e. all the files under the Tests folder) and also exclude files that have _/BuiltInPackages/_ in their path (i.e. all the built-in packages).

**Note:** `-debugCodeOptimization` is passed above to ensure Code optimization is set to Debug mode. See [Using Code Coverage with Code Optimization](UsingCodeCoverage.md#using-code-coverage-with-code-optimization).

## Generate combined report from EditMode and PlayMode tests

To get coverage information for both EditMode and PlayMode tests, run the editor three times as shown in the example below:
```
Unity.exe -projectPath <path-to-project> -batchmode -testPlatform editmode -runTests -debugCodeOptimization -enableCodeCoverage -coverageResultsPath <path-to-coverage-results>
-coverageOptions generateAdditionalMetrics;assemblyFilters:+my.assembly.*

Unity.exe -projectPath <path-to-project> -batchmode -testPlatform playmode -runTests -debugCodeOptimization -enableCodeCoverage -coverageResultsPath <path-to-coverage-results>
-coverageOptions generateAdditionalMetrics;assemblyFilters:+my.assembly.*

Unity.exe -projectPath <path-to-project> -batchmode -debugCodeOptimization -enableCodeCoverage -coverageResultsPath <path-to-coverage-results>
-coverageOptions generateHtmlReport;generateBadgeReport;assemblyFilters:+my.assembly.* -quit
```
The first will generate the coverage results for the EditMode tests, the second will generate the coverage results for the PlayMode tests and the third will generate the coverage report and summary badges based on both coverage results.

## Generate combined report from separate projects

To get a coverage report for your shared code which is used on separate projects, run the tests for each project making sure the *-coverageResultsPath* points to a separate location inside a shared root folder as shown in the example below:
```
Unity.exe -projectPath <path-to-project-01> -batchmode -testPlatform playmode -runTests -debugCodeOptimization -enableCodeCoverage -coverageResultsPath <path-to-coverage-results/project-01>
-coverageOptions generateAdditionalMetrics;assemblyFilters:+my.assembly.*

Unity.exe -projectPath <path-to-project-02> -batchmode -testPlatform playmode -runTests -debugCodeOptimization -enableCodeCoverage -coverageResultsPath <path-to-coverage-results/project-02>
-coverageOptions generateAdditionalMetrics;assemblyFilters:+my.assembly.*

Unity.exe -projectPath <path-to-project-01> -batchmode -debugCodeOptimization -enableCodeCoverage -coverageResultsPath <path-to-coverage-results>
-coverageOptions generateHtmlReport;generateBadgeReport;assemblyFilters:+my.assembly.* -quit
```
The first run will generate the coverage results for the PlayMode tests for *Project-01* and store these in *path-to-coverage-results/project-01*, the second run will generate the coverage results for the PlayMode tests for *Project-02* and store these in *path-to-coverage-results/project-02* and the third run will generate the coverage report and summary badges based on the results found under the common *path-to-coverage-results* folder.
